﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Core;

namespace Mdws2ORM
{
    static class Utilities
    {
        public static void ForEach<T>(this IEnumerable<T> enumerable, Action<T> action)
        {
            foreach (T t in enumerable)
            {
                action(t);
            }
        }

        public static string GetIen(string iens)
        {
            int index = iens.IndexOf(',');
            return index == -1 ?
                    iens :
                    iens.Substring(0, index);
        }

        public static string MakeGetIens(Entry entry, string iens)
        {
            return entry.Ien + iens;
        }

        public static string MakeListIens(Entry entry, string iens )
        {
            if (iens == "") iens = ",";
            return string.Format(",{0}{1}", entry.Ien, iens);
        }

        public static bool IsNullOrEmtpy<T>( IEnumerable<T> enumerable )
        {
            return enumerable == null || !enumerable.Any();
        }

      

    }
}
